/*******************************************************************************
 * Copyright (c) 2017 itemis AG and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Karsten Thoms <karsten.thoms@itemis.de> - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.cocoa;

public enum Selector {
	  sel_identity("identity")
	, sel_sendSearchSelection("sendSearchSelection")
	, sel_sendCancelSelection("sendCancelSelection")
	, sel_sendSelection("sendSelection")
	, sel_sendSelection_("sendSelection:")
	, sel_sendDoubleSelection("sendDoubleSelection")
	, sel_sendVerticalSelection("sendVerticalSelection")
	, sel_sendHorizontalSelection("sendHorizontalSelection")
	, sel_timerProc_("timerProc:")
	, sel_handleNotification_("handleNotification:")
	, sel_callJava("callJava:index:token:arg:")
	, sel_callRunBeforeUnloadConfirmPanelWithMessage("callRunBeforeUnloadConfirmPanelWithMessage:arg:")
	, sel_createPanelDidEnd("createPanelDidEnd:returnCode:contextInfo:")
	, sel_systemColorSettingsChanged_("systemSettingsChanged:")
	, sel_screenParametersChanged_("screenParametersChanged:")
	, sel_panelDidEnd_returnCode_contextInfo_("panelDidEnd:returnCode:contextInfo:")
	, sel_updateOpenGLContext_("updateOpenGLContext:")
	, sel_overwriteExistingFileCheck("_overwriteExistingFileCheck:")
	, sel_setShowsHiddenFiles_("setShowsHiddenFiles:")
	, sel_contextID("contextID")
	, sel__drawThemeProgressArea_("_drawThemeProgressArea:")

	, sel__setDashboardBehavior("_setDashboardBehavior:to:")

	, sel__setNeedsToUseHeartBeatWindow_("_setNeedsToUseHeartBeatWindow:")

	, sel_sharedHandler("sharedHandler")
	, sel_startAuthentication("startAuthentication:window:")
	, sel_setAllowsAnyHTTPSCertificate("setAllowsAnyHTTPSCertificate:forHost:")

	, sel_accessibleHandle("accessibleHandle")
	, sel_getImageView("getImageView")

	, sel_clearDeferFlushing("clearDeferFlushing")

	, sel_setShouldExpandItem_("setShouldExpandItem:")
	, sel_setShouldScrollClipView_("setShouldScrollClipView:")

	, sel_setQuota("setQuota:")
	, sel_webView_frame_exceededDatabaseQuotaForSecurityOrigin_database("webView:frame:exceededDatabaseQuotaForSecurityOrigin:database:")

	, sel_beginSheetModalForWindow_completionHandler_("beginSheetModalForWindow:completionHandler:")

	/** custom selector for SWT.OpenUrl event, also used in the launcher **/
	, sel_application_openUrls_("application:openUrls:")

	/** non-API selector for NSCursor **/
	, sel_busyButClickableCursor("busyButClickableCursor")

	/* These are not generated in order to avoid creating static methods on all classes */
	, sel_isSelectorExcludedFromWebScript_("isSelectorExcludedFromWebScript:")
	, sel_webScriptNameForSelector_("webScriptNameForSelector:")

	, sel_setColor_forAttribute_("setColor:forAttribute:")

	, sel_javaRunLoopMode("javaRunLoopMode")

	/* These are not generated in order to avoid attempting to create a java method called "null" */
	, class_NSNull("NSNull")
	, sel_null("null")

	, sel_cellBaselineOffset("cellBaselineOffset")

	/** 10.7 selectors and constants */
	, sel_isCompatibleWithOverlayScrollers("isCompatibleWithOverlayScrollers")
	, sel_flashScrollers("flashScrollers")
	, sel_frameSizeForContentSize_horizontalScrollerClass_verticalScrollerClass_borderType_controlSize_scrollerStyle_("frameSizeForContentSize:horizontalScrollerClass:verticalScrollerClass:borderType:controlSize:scrollerStyle:")
	, sel_scrollerStyle("scrollerStyle")
	, sel_toggleFullScreen_("toggleFullScreen:")

	/** 10.12 selector */
	, sel_setAllowsAutomaticWindowTabbing("setAllowsAutomaticWindowTabbing:")

	, sel_awtAppDelegate("awtAppDelegate")

	  /** This section is auto generated */

	, sel_CGEvent("CGEvent")
	, sel_DOMDocument("DOMDocument")
	, sel_IBeamCursor("IBeamCursor")
	, sel_PMPrintSession("PMPrintSession")
	, sel_PMPrintSettings("PMPrintSettings")
	, sel_TIFFRepresentation("TIFFRepresentation")
	, sel_URL("URL")
	, sel_URLFromPasteboard_("URLFromPasteboard:")
	, sel_URLWithString_("URLWithString:")
	, sel_URLsForDirectory_inDomains_("URLsForDirectory:inDomains:")
	, sel_UTF8String("UTF8String")
	, sel_abortEditing("abortEditing")
	, sel_absoluteString("absoluteString")
	, sel_acceptsFirstMouse_("acceptsFirstMouse:")
	, sel_acceptsFirstResponder("acceptsFirstResponder")
	, sel_accessibilityActionDescription_("accessibilityActionDescription:")
	, sel_accessibilityActionNames("accessibilityActionNames")
	, sel_accessibilityAttributeNames("accessibilityAttributeNames")
	, sel_accessibilityAttributeValue_("accessibilityAttributeValue:")
	, sel_accessibilityAttributeValue_forParameter_("accessibilityAttributeValue:forParameter:")
	, sel_accessibilityFocusedUIElement("accessibilityFocusedUIElement")
	, sel_accessibilityHitTest_("accessibilityHitTest:")
	, sel_accessibilityIsAttributeSettable_("accessibilityIsAttributeSettable:")
	, sel_accessibilityIsIgnored("accessibilityIsIgnored")
	, sel_accessibilityParameterizedAttributeNames("accessibilityParameterizedAttributeNames")
	, sel_accessibilityPerformAction_("accessibilityPerformAction:")
	, sel_accessibilitySetOverrideValue_forAttribute_("accessibilitySetOverrideValue:forAttribute:")
	, sel_accessibilitySetValue_forAttribute_("accessibilitySetValue:forAttribute:")
	, sel_action("action")
	, sel_activateIgnoringOtherApps_("activateIgnoringOtherApps:")
	, sel_activateWithOptions_("activateWithOptions:")
	, sel_addAttribute_value_range_("addAttribute:value:range:")
	, sel_addButtonWithTitle_("addButtonWithTitle:")
	, sel_addChildWindow_ordered_("addChildWindow:ordered:")
	, sel_addClip("addClip")
	, sel_addEventListener_listener_useCapture_("addEventListener:listener:useCapture:")
	, sel_addIndex_("addIndex:")
	, sel_addItem_("addItem:")
	, sel_addItemWithObjectValue_("addItemWithObjectValue:")
	, sel_addItemWithTitle_action_keyEquivalent_("addItemWithTitle:action:keyEquivalent:")
	, sel_addLayoutManager_("addLayoutManager:")
	, sel_addObject_("addObject:")
	, sel_addObjectsFromArray_("addObjectsFromArray:")
	, sel_addObserver_selector_name_object_("addObserver:selector:name:object:")
	, sel_addRepresentation_("addRepresentation:")
	, sel_addSubview_("addSubview:")
	, sel_addSubview_positioned_relativeTo_("addSubview:positioned:relativeTo:")
	, sel_addTabStop_("addTabStop:")
	, sel_addTabViewItem_("addTabViewItem:")
	, sel_addTableColumn_("addTableColumn:")
	, sel_addTemporaryAttribute_value_forCharacterRange_("addTemporaryAttribute:value:forCharacterRange:")
	, sel_addTextContainer_("addTextContainer:")
	, sel_addTimer_forMode_("addTimer:forMode:")
	, sel_addToolTipRect_owner_userData_("addToolTipRect:owner:userData:")
	, sel_addTypes_owner_("addTypes:owner:")
	, sel_alignment("alignment")
	, sel_allKeys("allKeys")
	, sel_allObjects("allObjects")
	, sel_alloc("alloc")
	, sel_allowsColumnReordering("allowsColumnReordering")
	, sel_allowsFloats("allowsFloats")
	, sel_alphaComponent("alphaComponent")
	, sel_alphaValue("alphaValue")
	, sel_altKey("altKey")
	, sel_alternateSelectedControlColor("alternateSelectedControlColor")
	, sel_alternateSelectedControlTextColor("alternateSelectedControlTextColor")
	, sel_alwaysShowsDecimalSeparator("alwaysShowsDecimalSeparator")
	, sel_appendAttributedString_("appendAttributedString:")
	, sel_appendBezierPath_("appendBezierPath:")
	, sel_appendBezierPathWithArcWithCenter_radius_startAngle_endAngle_("appendBezierPathWithArcWithCenter:radius:startAngle:endAngle:")
	, sel_appendBezierPathWithArcWithCenter_radius_startAngle_endAngle_clockwise_("appendBezierPathWithArcWithCenter:radius:startAngle:endAngle:clockwise:")
	, sel_appendBezierPathWithGlyphs_count_inFont_("appendBezierPathWithGlyphs:count:inFont:")
	, sel_appendBezierPathWithOvalInRect_("appendBezierPathWithOvalInRect:")
	, sel_appendBezierPathWithRect_("appendBezierPathWithRect:")
	, sel_appendBezierPathWithRoundedRect_xRadius_yRadius_("appendBezierPathWithRoundedRect:xRadius:yRadius:")
	, sel_appendString_("appendString:")
	, sel_application_openFile_("application:openFile:")
	, sel_application_openFiles_("application:openFiles:")
	, sel_applicationDidBecomeActive_("applicationDidBecomeActive:")
	, sel_applicationDidFinishLaunching_("applicationDidFinishLaunching:")
	, sel_applicationDidResignActive_("applicationDidResignActive:")
	, sel_applicationDockMenu_("applicationDockMenu:")
	, sel_applicationIconImage("applicationIconImage")
	, sel_applicationShouldHandleReopen_hasVisibleWindows_("applicationShouldHandleReopen:hasVisibleWindows:")
	, sel_applicationShouldTerminate_("applicationShouldTerminate:")
	, sel_applicationWillFinishLaunching_("applicationWillFinishLaunching:")
	, sel_applicationWillTerminate_("applicationWillTerminate:")
	, sel_archivedDataWithRootObject_("archivedDataWithRootObject:")
	, sel_areCursorRectsEnabled("areCursorRectsEnabled")
	, sel_arrangeInFront_("arrangeInFront:")
	, sel_array("array")
	, sel_arrayWithCapacity_("arrayWithCapacity:")
	, sel_arrayWithObject_("arrayWithObject:")
	, sel_arrowCursor("arrowCursor")
	, sel_ascender("ascender")
	, sel_attachColorList_("attachColorList:")
	, sel_attachment("attachment")
	, sel_attribute_atIndex_effectiveRange_("attribute:atIndex:effectiveRange:")
	, sel_attributedStringValue("attributedStringValue")
	, sel_attributedStringWithAttachment_("attributedStringWithAttachment:")
	, sel_attributedSubstringFromRange_("attributedSubstringFromRange:")
	, sel_attributedTitle("attributedTitle")
	, sel_attributesAtIndex_longestEffectiveRange_inRange_("attributesAtIndex:longestEffectiveRange:inRange:")
	, sel_autorelease("autorelease")
	, sel_availableFontFamilies("availableFontFamilies")
	, sel_availableFonts("availableFonts")
	, sel_availableMembersOfFontFamily_("availableMembersOfFontFamily:")
	, sel_availableTypeFromArray_("availableTypeFromArray:")
	, sel_backgroundColor("backgroundColor")
	, sel_backingScaleFactor("backingScaleFactor")
	, sel_badgeLabel("badgeLabel")
	, sel_baselineOffsetInLayoutManager_glyphIndex_("baselineOffsetInLayoutManager:glyphIndex:")
	, sel_becomeFirstResponder("becomeFirstResponder")
	, sel_becomeKeyWindow("becomeKeyWindow")
	, sel_beginDocument("beginDocument")
	, sel_beginEditing("beginEditing")
	, sel_beginGestureWithEvent_("beginGestureWithEvent:")
	, sel_beginPageInRect_atPlacement_("beginPageInRect:atPlacement:")
	, sel_beginSheet_modalForWindow_modalDelegate_didEndSelector_contextInfo_("beginSheet:modalForWindow:modalDelegate:didEndSelector:contextInfo:")
	, sel_beginSheetForWindow_modalDelegate_didEndSelector_contextInfo_trust_message_("beginSheetForWindow:modalDelegate:didEndSelector:contextInfo:trust:message:")
	, sel_beginSheetModalForWindow_modalDelegate_didEndSelector_contextInfo_("beginSheetModalForWindow:modalDelegate:didEndSelector:contextInfo:")
	, sel_beginSheetWithPrintInfo_modalForWindow_delegate_didEndSelector_contextInfo_("beginSheetWithPrintInfo:modalForWindow:delegate:didEndSelector:contextInfo:")
	, sel_bestRepresentationForDevice_("bestRepresentationForDevice:")
	, sel_bezelStyle("bezelStyle")
	, sel_bezierPath("bezierPath")
	, sel_bezierPathByFlatteningPath("bezierPathByFlatteningPath")
	, sel_bezierPathWithRect_("bezierPathWithRect:")
	, sel_bezierPathWithRoundedRect_xRadius_yRadius_("bezierPathWithRoundedRect:xRadius:yRadius:")
	, sel_bitmapData("bitmapData")
	, sel_bitmapFormat("bitmapFormat")
	, sel_bitmapImageRepForCachingDisplayInRect_("bitmapImageRepForCachingDisplayInRect:")
	, sel_bitsPerPixel("bitsPerPixel")
	, sel_bitsPerSample("bitsPerSample")
	, sel_blackColor("blackColor")
	, sel_blueComponent("blueComponent")
	, sel_boldSystemFontOfSize_("boldSystemFontOfSize:")
	, sel_boolValue("boolValue")
	, sel_borderWidth("borderWidth")
	, sel_boundingRectForGlyphRange_inTextContainer_("boundingRectForGlyphRange:inTextContainer:")
	, sel_boundingRectWithSize_options_("boundingRectWithSize:options:")
	, sel_bounds("bounds")
	, sel_bundleIdentifier("bundleIdentifier")
	, sel_bundlePath("bundlePath")
	, sel_bundleWithIdentifier_("bundleWithIdentifier:")
	, sel_bundleWithPath_("bundleWithPath:")
	, sel_button("button")
	, sel_buttonNumber("buttonNumber")
	, sel_bytes("bytes")
	, sel_bytesPerPlane("bytesPerPlane")
	, sel_bytesPerRow("bytesPerRow")
	, sel_cacheDisplayInRect_toBitmapImageRep_("cacheDisplayInRect:toBitmapImageRep:")
	, sel_calendarDate("calendarDate")
	, sel_canBecomeKeyView("canBecomeKeyView")
	, sel_canBecomeKeyWindow("canBecomeKeyWindow")
	, sel_canDragRowsWithIndexes_atPoint_("canDragRowsWithIndexes:atPoint:")
	, sel_canGoBack("canGoBack")
	, sel_canGoForward("canGoForward")
	, sel_canRedo("canRedo")
	, sel_canShowMIMEType_("canShowMIMEType:")
	, sel_canUndo("canUndo")
	, sel_cancel("cancel")
	, sel_cancelAuthenticationChallenge_("cancelAuthenticationChallenge:")
	, sel_cancelButtonCell("cancelButtonCell")
	, sel_cancelButtonRectForBounds_("cancelButtonRectForBounds:")
	, sel_cancelOperation_("cancelOperation:")
	, sel_cancelTracking("cancelTracking")
	, sel_cascadeTopLeftFromPoint_("cascadeTopLeftFromPoint:")
	, sel_cell("cell")
	, sel_cellClass("cellClass")
	, sel_cellSize("cellSize")
	, sel_cellSizeForBounds_("cellSizeForBounds:")
	, sel_changeColor_("changeColor:")
	, sel_changeFont_("changeFont:")
	, sel_charCode("charCode")
	, sel_characterAtIndex_("characterAtIndex:")
	, sel_characterIndexForGlyphAtIndex_("characterIndexForGlyphAtIndex:")
	, sel_characterIndexForInsertionAtPoint_("characterIndexForInsertionAtPoint:")
	, sel_characterIndexForPoint_("characterIndexForPoint:")
	, sel_characterIsMember_("characterIsMember:")
	, sel_characters("characters")
	, sel_charactersIgnoringModifiers("charactersIgnoringModifiers")
	, sel_chooseFilename_("chooseFilename:")
	, sel_className("className")
	, sel_cleanUpOperation("cleanUpOperation")
	, sel_clearColor("clearColor")
	, sel_clearCurrentContext("clearCurrentContext")
	, sel_clearDrawable("clearDrawable")
	, sel_clickCount("clickCount")
	, sel_clickedColumn("clickedColumn")
	, sel_clickedRow("clickedRow")
	, sel_close("close")
	, sel_closePath("closePath")
	, sel_code("code")
	, sel_collapseItem_("collapseItem:")
	, sel_collapseItem_collapseChildren_("collapseItem:collapseChildren:")
	, sel_collectionBehavior("collectionBehavior")
	, sel_color("color")
	, sel_colorAtX_y_("colorAtX:y:")
	, sel_colorListNamed_("colorListNamed:")
	, sel_colorSpace("colorSpace")
	, sel_colorSpaceModel("colorSpaceModel")
	, sel_colorSpaceName("colorSpaceName")
	, sel_colorUsingColorSpaceName_("colorUsingColorSpaceName:")
	, sel_colorWithCalibratedRed_green_blue_alpha_("colorWithCalibratedRed:green:blue:alpha:")
	, sel_colorWithDeviceRed_green_blue_alpha_("colorWithDeviceRed:green:blue:alpha:")
	, sel_colorWithKey_("colorWithKey:")
	, sel_colorWithPatternImage_("colorWithPatternImage:")
	, sel_columnAtPoint_("columnAtPoint:")
	, sel_columnIndexesInRect_("columnIndexesInRect:")
	, sel_columnWithIdentifier_("columnWithIdentifier:")
	, sel_comboBoxSelectionDidChange_("comboBoxSelectionDidChange:")
	, sel_comboBoxWillDismiss_("comboBoxWillDismiss:")
	, sel_comboBoxWillPopUp_("comboBoxWillPopUp:")
	, sel_compare_("compare:")
	, sel_concat("concat")
	, sel_conformsToProtocol_("conformsToProtocol:")
	, sel_containerSize("containerSize")
	, sel_containsIndex_("containsIndex:")
	, sel_containsObject_("containsObject:")
	, sel_containsPoint_("containsPoint:")
	, sel_contentRect("contentRect")
	, sel_contentSize("contentSize")
	, sel_contentSizeForFrameSize_hasHorizontalScroller_hasVerticalScroller_borderType_("contentSizeForFrameSize:hasHorizontalScroller:hasVerticalScroller:borderType:")
	, sel_contentView("contentView")
	, sel_contentViewMargins("contentViewMargins")
	, sel_context("context")
	, sel_controlBackgroundColor("controlBackgroundColor")
	, sel_controlContentFontOfSize_("controlContentFontOfSize:")
	, sel_controlDarkShadowColor("controlDarkShadowColor")
	, sel_controlHighlightColor("controlHighlightColor")
	, sel_controlLightHighlightColor("controlLightHighlightColor")
	, sel_controlPointBounds("controlPointBounds")
	, sel_controlShadowColor("controlShadowColor")
	, sel_controlSize("controlSize")
	, sel_controlTextColor("controlTextColor")
	, sel_convertBaseToScreen_("convertBaseToScreen:")
	, sel_convertFont_toHaveTrait_("convertFont:toHaveTrait:")
	, sel_convertPoint_fromView_("convertPoint:fromView:")
	, sel_convertPoint_toView_("convertPoint:toView:")
	, sel_convertPointFromBase_("convertPointFromBase:")
	, sel_convertPointToBase_("convertPointToBase:")
	, sel_convertRect_fromView_("convertRect:fromView:")
	, sel_convertRect_toView_("convertRect:toView:")
	, sel_convertRectFromBase_("convertRectFromBase:")
	, sel_convertRectToBase_("convertRectToBase:")
	, sel_convertScreenToBase_("convertScreenToBase:")
	, sel_convertSize_fromView_("convertSize:fromView:")
	, sel_convertSize_toView_("convertSize:toView:")
	, sel_convertSizeFromBase_("convertSizeFromBase:")
	, sel_convertSizeToBase_("convertSizeToBase:")
	, sel_cookies("cookies")
	, sel_cookiesForURL_("cookiesForURL:")
	, sel_cookiesWithResponseHeaderFields_forURL_("cookiesWithResponseHeaderFields:forURL:")
	, sel_copiesOnScroll("copiesOnScroll")
	, sel_copy("copy")
	, sel_copy_("copy:")
	, sel_count("count")
	, sel_createContext("createContext")
	, sel_createFileAtPath_contents_attributes_("createFileAtPath:contents:attributes:")
	, sel_credentialWithUser_password_persistence_("credentialWithUser:password:persistence:")
	, sel_crosshairCursor("crosshairCursor")
	, sel_ctrlKey("ctrlKey")
	, sel_currentApplication("currentApplication")
	, sel_currentContext("currentContext")
	, sel_currentCursor("currentCursor")
	, sel_currentEditor("currentEditor")
	, sel_currentEvent("currentEvent")
	, sel_currentHandler("currentHandler")
	, sel_currentInputManager("currentInputManager")
	, sel_currentPoint("currentPoint")
	, sel_currentRunLoop("currentRunLoop")
	, sel_currentThread("currentThread")
	, sel_cursorUpdate_("cursorUpdate:")
	, sel_curveToPoint_controlPoint1_controlPoint2_("curveToPoint:controlPoint1:controlPoint2:")
	, sel_cut_("cut:")
	, sel_dataCell("dataCell")
	, sel_dataForType_("dataForType:")
	, sel_dataSource("dataSource")
	, sel_dataWithBytes_length_("dataWithBytes:length:")
	, sel_dateValue("dateValue")
	, sel_dateWithCalendarFormat_timeZone_("dateWithCalendarFormat:timeZone:")
	, sel_dateWithTimeIntervalSinceNow_("dateWithTimeIntervalSinceNow:")
	, sel_dateWithYear_month_day_hour_minute_second_timeZone_("dateWithYear:month:day:hour:minute:second:timeZone:")
	, sel_dayOfMonth("dayOfMonth")
	, sel_dealloc("dealloc")
	, sel_decimalDigitCharacterSet("decimalDigitCharacterSet")
	, sel_decimalSeparator("decimalSeparator")
	, sel_declareTypes_owner_("declareTypes:owner:")
	, sel_defaultBaselineOffsetForFont_("defaultBaselineOffsetForFont:")
	, sel_defaultButtonCell("defaultButtonCell")
	, sel_defaultCenter("defaultCenter")
	, sel_defaultFlatness("defaultFlatness")
	, sel_defaultLineHeightForFont_("defaultLineHeightForFont:")
	, sel_defaultManager("defaultManager")
	, sel_defaultParagraphStyle("defaultParagraphStyle")
	, sel_defaultPrinter("defaultPrinter")
	, sel_defaultTimeZone("defaultTimeZone")
	, sel_delegate("delegate")
	, sel_deleteCookie_("deleteCookie:")
	, sel_deliverResult("deliverResult")
	, sel_deltaX("deltaX")
	, sel_deltaY("deltaY")
	, sel_deminiaturize_("deminiaturize:")
	, sel_depth("depth")
	, sel_descender("descender")
	, sel_description("description")
	, sel_deselectAll_("deselectAll:")
	, sel_deselectItemAtIndex_("deselectItemAtIndex:")
	, sel_deselectRow_("deselectRow:")
	, sel_destroyContext("destroyContext")
	, sel_detail("detail")
	, sel_device("device")
	, sel_deviceDescription("deviceDescription")
	, sel_deviceSize("deviceSize")
	, sel_dictionary("dictionary")
	, sel_dictionaryWithCapacity_("dictionaryWithCapacity:")
	, sel_dictionaryWithObject_forKey_("dictionaryWithObject:forKey:")
	, sel_disableCursorRects("disableCursorRects")
	, sel_disableFlushWindow("disableFlushWindow")
	, sel_disabledControlTextColor("disabledControlTextColor")
	, sel_discardCursorRects("discardCursorRects")
	, sel_display("display")
	, sel_displayIfNeeded("displayIfNeeded")
	, sel_displayName("displayName")
	, sel_displayNameForKey_value_("displayNameForKey:value:")
	, sel_displayRectIgnoringOpacity_inContext_("displayRectIgnoringOpacity:inContext:")
	, sel_distantFuture("distantFuture")
	, sel_doCommandBySelector_("doCommandBySelector:")
	, sel_dockTile("dockTile")
	, sel_documentCursor("documentCursor")
	, sel_documentSource("documentSource")
	, sel_documentView("documentView")
	, sel_documentViewShouldHandlePrint("documentViewShouldHandlePrint")
	, sel_documentVisibleRect("documentVisibleRect")
	, sel_doubleClickAtIndex_("doubleClickAtIndex:")
	, sel_doubleValue("doubleValue")
	, sel_download("download")
	, sel_download_decideDestinationWithSuggestedFilename_("download:decideDestinationWithSuggestedFilename:")
	, sel_dragImage_at_offset_event_pasteboard_source_slideBack_("dragImage:at:offset:event:pasteboard:source:slideBack:")
	, sel_dragImageForRowsWithIndexes_tableColumns_event_offset_("dragImageForRowsWithIndexes:tableColumns:event:offset:")
	, sel_dragSelectionWithEvent_offset_slideBack_("dragSelectionWithEvent:offset:slideBack:")
	, sel_draggedImage_beganAt_("draggedImage:beganAt:")
	, sel_draggedImage_endedAt_operation_("draggedImage:endedAt:operation:")
	, sel_draggingDestinationWindow("draggingDestinationWindow")
	, sel_draggingEnded_("draggingEnded:")
	, sel_draggingEntered_("draggingEntered:")
	, sel_draggingExited_("draggingExited:")
	, sel_draggingLocation("draggingLocation")
	, sel_draggingPasteboard("draggingPasteboard")
	, sel_draggingSourceOperationMask("draggingSourceOperationMask")
	, sel_draggingSourceOperationMaskForLocal_("draggingSourceOperationMaskForLocal:")
	, sel_draggingUpdated_("draggingUpdated:")
	, sel_drawAtPoint_("drawAtPoint:")
	, sel_drawAtPoint_fromRect_operation_fraction_("drawAtPoint:fromRect:operation:fraction:")
	, sel_drawBackgroundForGlyphRange_atPoint_("drawBackgroundForGlyphRange:atPoint:")
	, sel_drawBackgroundInClipRect_("drawBackgroundInClipRect:")
	, sel_drawBezelWithFrame_inView_("drawBezelWithFrame:inView:")
	, sel_drawFromPoint_toPoint_options_("drawFromPoint:toPoint:options:")
	, sel_drawGlyphsForGlyphRange_atPoint_("drawGlyphsForGlyphRange:atPoint:")
	, sel_drawImage_withFrame_inView_("drawImage:withFrame:inView:")
	, sel_drawInBezierPath_angle_("drawInBezierPath:angle:")
	, sel_drawInRect_("drawInRect:")
	, sel_drawInRect_angle_("drawInRect:angle:")
	, sel_drawInRect_fromRect_operation_fraction_("drawInRect:fromRect:operation:fraction:")
	, sel_drawInteriorWithFrame_inView_("drawInteriorWithFrame:inView:")
	, sel_drawLabel_inRect_("drawLabel:inRect:")
	, sel_drawRect_("drawRect:")
	, sel_drawSortIndicatorWithFrame_inView_ascending_priority_("drawSortIndicatorWithFrame:inView:ascending:priority:")
	, sel_drawStatusBarBackgroundInRect_withHighlight_("drawStatusBarBackgroundInRect:withHighlight:")
	, sel_drawTitle_withFrame_inView_("drawTitle:withFrame:inView:")
	, sel_drawViewBackgroundInRect_("drawViewBackgroundInRect:")
	, sel_drawWithExpansionFrame_inView_("drawWithExpansionFrame:inView:")
	, sel_drawingRectForBounds_("drawingRectForBounds:")
	, sel_elementAtIndex_associatedPoints_("elementAtIndex:associatedPoints:")
	, sel_elementCount("elementCount")
	, sel_enableCursorRects("enableCursorRects")
	, sel_enableFlushWindow("enableFlushWindow")
	, sel_endDocument("endDocument")
	, sel_endEditing("endEditing")
	, sel_endEditingFor_("endEditingFor:")
	, sel_endGestureWithEvent_("endGestureWithEvent:")
	, sel_endPage("endPage")
	, sel_endSheet_returnCode_("endSheet:returnCode:")
	, sel_enterExitEventWithType_location_modifierFlags_timestamp_windowNumber_context_eventNumber_trackingNumber_userData_("enterExitEventWithType:location:modifierFlags:timestamp:windowNumber:context:eventNumber:trackingNumber:userData:")
	, sel_enumeratorAtPath_("enumeratorAtPath:")
	, sel_expandItem_("expandItem:")
	, sel_expandItem_expandChildren_("expandItem:expandChildren:")
	, sel_expansionFrameWithFrame_inView_("expansionFrameWithFrame:inView:")
	, sel_familyName("familyName")
	, sel_fieldEditor_forObject_("fieldEditor:forObject:")
	, sel_fileExistsAtPath_("fileExistsAtPath:")
	, sel_fileExistsAtPath_isDirectory_("fileExistsAtPath:isDirectory:")
	, sel_fileSystemRepresentation("fileSystemRepresentation")
	, sel_fileURLWithPath_("fileURLWithPath:")
	, sel_filename("filename")
	, sel_filenames("filenames")
	, sel_fill("fill")
	, sel_fillRect_("fillRect:")
	, sel_finishLaunching("finishLaunching")
	, sel_firstIndex("firstIndex")
	, sel_firstRectForCharacterRange_("firstRectForCharacterRange:")
	, sel_firstResponder("firstResponder")
	, sel_flagsChanged_("flagsChanged:")
	, sel_floatValue("floatValue")
	, sel_flushBuffer("flushBuffer")
	, sel_flushGraphics("flushGraphics")
	, sel_flushWindowIfNeeded("flushWindowIfNeeded")
	, sel_focusRingMaskBoundsForFrame_inView_("focusRingMaskBoundsForFrame:inView:")
	, sel_font("font")
	, sel_fontName("fontName")
	, sel_fontWithFamily_traits_weight_size_("fontWithFamily:traits:weight:size:")
	, sel_fontWithName_size_("fontWithName:size:")
	, sel_frame("frame")
	, sel_frameOfCellAtColumn_row_("frameOfCellAtColumn:row:")
	, sel_frameOfOutlineCellAtRow_("frameOfOutlineCellAtRow:")
	, sel_frameRectForContentRect_("frameRectForContentRect:")
	, sel_frameSizeForContentSize_hasHorizontalScroller_hasVerticalScroller_borderType_("frameSizeForContentSize:hasHorizontalScroller:hasVerticalScroller:borderType:")
	, sel_fullPathForApplication_("fullPathForApplication:")
	, sel_generalPasteboard("generalPasteboard")
	, sel_genericRGBColorSpace("genericRGBColorSpace")
	, sel_getBitmapDataPlanes_("getBitmapDataPlanes:")
	, sel_getBytes_("getBytes:")
	, sel_getBytes_length_("getBytes:length:")
	, sel_getCharacters_("getCharacters:")
	, sel_getCharacters_range_("getCharacters:range:")
	, sel_getComponents_("getComponents:")
	, sel_getGlyphs_range_("getGlyphs:range:")
	, sel_getGlyphsInRange_glyphs_characterIndexes_glyphInscriptions_elasticBits_bidiLevels_("getGlyphsInRange:glyphs:characterIndexes:glyphInscriptions:elasticBits:bidiLevels:")
	, sel_getIndexes_maxCount_inIndexRange_("getIndexes:maxCount:inIndexRange:")
	, sel_getInfoForFile_application_type_("getInfoForFile:application:type:")
	, sel_getValues_forAttribute_forVirtualScreen_("getValues:forAttribute:forVirtualScreen:")
	, sel_globalContext("globalContext")
	, sel_glyphIndexForCharacterAtIndex_("glyphIndexForCharacterAtIndex:")
	, sel_glyphIndexForPoint_inTextContainer_fractionOfDistanceThroughGlyph_("glyphIndexForPoint:inTextContainer:fractionOfDistanceThroughGlyph:")
	, sel_glyphRangeForCharacterRange_actualCharacterRange_("glyphRangeForCharacterRange:actualCharacterRange:")
	, sel_glyphRangeForTextContainer_("glyphRangeForTextContainer:")
	, sel_goBack("goBack")
	, sel_goForward("goForward")
	, sel_graphicsContext("graphicsContext")
	, sel_graphicsContextWithBitmapImageRep_("graphicsContextWithBitmapImageRep:")
	, sel_graphicsContextWithGraphicsPort_flipped_("graphicsContextWithGraphicsPort:flipped:")
	, sel_graphicsContextWithWindow_("graphicsContextWithWindow:")
	, sel_graphicsPort("graphicsPort")
	, sel_greenComponent("greenComponent")
	, sel_handleEvent_("handleEvent:")
	, sel_handleFailureInFunction_file_lineNumber_description_("handleFailureInFunction:file:lineNumber:description:")
	, sel_handleFailureInMethod_object_file_lineNumber_description_("handleFailureInMethod:object:file:lineNumber:description:")
	, sel_handleMouseEvent_("handleMouseEvent:")
	, sel_hasAlpha("hasAlpha")
	, sel_hasMarkedText("hasMarkedText")
	, sel_hasPassword("hasPassword")
	, sel_hasShadow("hasShadow")
	, sel_headerCell("headerCell")
	, sel_headerRectOfColumn_("headerRectOfColumn:")
	, sel_headerView("headerView")
	, sel_helpRequested_("helpRequested:")
	, sel_hide_("hide:")
	, sel_hideOtherApplications_("hideOtherApplications:")
	, sel_highlightColorInView_("highlightColorInView:")
	, sel_highlightColorWithFrame_inView_("highlightColorWithFrame:inView:")
	, sel_highlightSelectionInClipRect_("highlightSelectionInClipRect:")
	, sel_hitPart("hitPart")
	, sel_hitTest_("hitTest:")
	, sel_hitTestForEvent_inRect_ofView_("hitTestForEvent:inRect:ofView:")
	, sel_host("host")
	, sel_hotSpot("hotSpot")
	, sel_hourOfDay("hourOfDay")
	, sel_iconForFile_("iconForFile:")
	, sel_iconForFileType_("iconForFileType:")
	, sel_ignore("ignore")
	, sel_ignoreModifierKeysWhileDragging("ignoreModifierKeysWhileDragging")
	, sel_image("image")
	, sel_imageInterpolation("imageInterpolation")
	, sel_imageNamed_("imageNamed:")
	, sel_imageRectForBounds_("imageRectForBounds:")
	, sel_imageRepWithContentsOfFile_("imageRepWithContentsOfFile:")
	, sel_imageRepWithData_("imageRepWithData:")
	, sel_imageablePageBounds("imageablePageBounds")
	, sel_increment("increment")
	, sel_indentationPerLevel("indentationPerLevel")
	, sel_indexOfItemWithTarget_andAction_("indexOfItemWithTarget:andAction:")
	, sel_indexOfObjectIdenticalTo_("indexOfObjectIdenticalTo:")
	, sel_indexOfSelectedItem("indexOfSelectedItem")
	, sel_indexSetWithIndex_("indexSetWithIndex:")
	, sel_infoDictionary("infoDictionary")
	, sel_init("init")
	, sel_initByReferencingFile_("initByReferencingFile:")
	, sel_initListDescriptor("initListDescriptor")
	, sel_initWithAttributes_("initWithAttributes:")
	, sel_initWithBitmapDataPlanes_pixelsWide_pixelsHigh_bitsPerSample_samplesPerPixel_hasAlpha_isPlanar_colorSpaceName_bitmapFormat_bytesPerRow_bitsPerPixel_("initWithBitmapDataPlanes:pixelsWide:pixelsHigh:bitsPerSample:samplesPerPixel:hasAlpha:isPlanar:colorSpaceName:bitmapFormat:bytesPerRow:bitsPerPixel:")
	, sel_initWithBitmapDataPlanes_pixelsWide_pixelsHigh_bitsPerSample_samplesPerPixel_hasAlpha_isPlanar_colorSpaceName_bytesPerRow_bitsPerPixel_("initWithBitmapDataPlanes:pixelsWide:pixelsHigh:bitsPerSample:samplesPerPixel:hasAlpha:isPlanar:colorSpaceName:bytesPerRow:bitsPerPixel:")
	, sel_initWithCapacity_("initWithCapacity:")
	, sel_initWithCharacters_length_("initWithCharacters:length:")
	, sel_initWithColors_("initWithColors:")
	, sel_initWithContainerSize_("initWithContainerSize:")
	, sel_initWithContentRect_styleMask_backing_defer_("initWithContentRect:styleMask:backing:defer:")
	, sel_initWithContentRect_styleMask_backing_defer_screen_("initWithContentRect:styleMask:backing:defer:screen:")
	, sel_initWithContentsOfFile_("initWithContentsOfFile:")
	, sel_initWithData_("initWithData:")
	, sel_initWithDictionary_("initWithDictionary:")
	, sel_initWithFileWrapper_("initWithFileWrapper:")
	, sel_initWithFocusedViewRect_("initWithFocusedViewRect:")
	, sel_initWithFormat_shareContext_("initWithFormat:shareContext:")
	, sel_initWithFrame_("initWithFrame:")
	, sel_initWithFrame_frameName_groupName_("initWithFrame:frameName:groupName:")
	, sel_initWithFrame_pullsDown_("initWithFrame:pullsDown:")
	, sel_initWithIconRef_("initWithIconRef:")
	, sel_initWithIdentifier_("initWithIdentifier:")
	, sel_initWithImage_hotSpot_("initWithImage:hotSpot:")
	, sel_initWithIndex_("initWithIndex:")
	, sel_initWithIndexSet_("initWithIndexSet:")
	, sel_initWithIndexesInRange_("initWithIndexesInRange:")
	, sel_initWithItemIdentifier_("initWithItemIdentifier:")
	, sel_initWithLocaleIdentifier_("initWithLocaleIdentifier:")
	, sel_initWithName_("initWithName:")
	, sel_initWithRect_options_owner_userInfo_("initWithRect:options:owner:userInfo:")
	, sel_initWithSize_("initWithSize:")
	, sel_initWithStartingColor_endingColor_("initWithStartingColor:endingColor:")
	, sel_initWithString_("initWithString:")
	, sel_initWithString_attributes_("initWithString:attributes:")
	, sel_initWithTitle_("initWithTitle:")
	, sel_initWithTitle_action_keyEquivalent_("initWithTitle:action:keyEquivalent:")
	, sel_initWithTransform_("initWithTransform:")
	, sel_initWithType_location_("initWithType:location:")
	, sel_initWithURL_("initWithURL:")
	, sel_insertColor_key_atIndex_("insertColor:key:atIndex:")
	, sel_insertItem_atIndex_("insertItem:atIndex:")
	, sel_insertItemWithItemIdentifier_atIndex_("insertItemWithItemIdentifier:atIndex:")
	, sel_insertItemWithObjectValue_atIndex_("insertItemWithObjectValue:atIndex:")
	, sel_insertTabViewItem_atIndex_("insertTabViewItem:atIndex:")
	, sel_insertText_("insertText:")
	, sel_intValue("intValue")
	, sel_integerValue("integerValue")
	, sel_intercellSpacing("intercellSpacing")
	, sel_interpretKeyEvents_("interpretKeyEvents:")
	, sel_invalidate("invalidate")
	, sel_invalidateShadow("invalidateShadow")
	, sel_invert("invert")
	, sel_isActive("isActive")
	, sel_isDescendantOf_("isDescendantOf:")
	, sel_isDocumentEdited("isDocumentEdited")
	, sel_isDrawingToScreen("isDrawingToScreen")
	, sel_isEmpty("isEmpty")
	, sel_isEnabled("isEnabled")
	, sel_isEqual_("isEqual:")
	, sel_isEqualTo_("isEqualTo:")
	, sel_isEqualToString_("isEqualToString:")
	, sel_isExecutableFileAtPath_("isExecutableFileAtPath:")
	, sel_isFieldEditor("isFieldEditor")
	, sel_isFilePackageAtPath_("isFilePackageAtPath:")
	, sel_isFileURL("isFileURL")
	, sel_isFlipped("isFlipped")
	, sel_isHidden("isHidden")
	, sel_isHiddenOrHasHiddenAncestor("isHiddenOrHasHiddenAncestor")
	, sel_isHighlighted("isHighlighted")
	, sel_isItemExpanded_("isItemExpanded:")
	, sel_isKeyWindow("isKeyWindow")
	, sel_isKindOfClass_("isKindOfClass:")
	, sel_isMainThread("isMainThread")
	, sel_isMainWindow("isMainWindow")
	, sel_isMiniaturized("isMiniaturized")
	, sel_isOpaque("isOpaque")
	, sel_isPlanar("isPlanar")
	, sel_isResting("isResting")
	, sel_isRowSelected_("isRowSelected:")
	, sel_isRunning("isRunning")
	, sel_isSelectionOnly("isSelectionOnly")
	, sel_isSeparatorItem("isSeparatorItem")
	, sel_isSessionOnly("isSessionOnly")
	, sel_isSheet("isSheet")
	, sel_isVisible("isVisible")
	, sel_isZoomed("isZoomed")
	, sel_itemArray("itemArray")
	, sel_itemAtIndex_("itemAtIndex:")
	, sel_itemAtRow_("itemAtRow:")
	, sel_itemHeight("itemHeight")
	, sel_itemIdentifier("itemIdentifier")
	, sel_itemObjectValueAtIndex_("itemObjectValueAtIndex:")
	, sel_itemTitleAtIndex_("itemTitleAtIndex:")
	, sel_itemWithTag_("itemWithTag:")
	, sel_jobDisposition("jobDisposition")
	, sel_keyCode("keyCode")
	, sel_keyDown_("keyDown:")
	, sel_keyEquivalent("keyEquivalent")
	, sel_keyEquivalentModifierMask("keyEquivalentModifierMask")
	, sel_keyUp_("keyUp:")
	, sel_keyWindow("keyWindow")
	, sel_knobProportion("knobProportion")
	, sel_knobThickness("knobThickness")
	, sel_lastPathComponent("lastPathComponent")
	, sel_layoutManager("layoutManager")
	, sel_leading("leading")
	, sel_length("length")
	, sel_level("level")
	, sel_levelForItem_("levelForItem:")
	, sel_lineFragmentUsedRectForGlyphAtIndex_effectiveRange_("lineFragmentUsedRectForGlyphAtIndex:effectiveRange:")
	, sel_lineFragmentUsedRectForGlyphAtIndex_effectiveRange_withoutAdditionalLayout_("lineFragmentUsedRectForGlyphAtIndex:effectiveRange:withoutAdditionalLayout:")
	, sel_lineToPoint_("lineToPoint:")
	, sel_linkTextAttributes("linkTextAttributes")
	, sel_loadHTMLString_baseURL_("loadHTMLString:baseURL:")
	, sel_loadNibFile_externalNameTable_withZone_("loadNibFile:externalNameTable:withZone:")
	, sel_loadRequest_("loadRequest:")
	, sel_localizedDescription("localizedDescription")
	, sel_location("location")
	, sel_locationForGlyphAtIndex_("locationForGlyphAtIndex:")
	, sel_locationInWindow("locationInWindow")
	, sel_lockFocus("lockFocus")
	, sel_lowercaseString("lowercaseString")
	, sel_magnification("magnification")
	, sel_magnifyWithEvent_("magnifyWithEvent:")
	, sel_mainBundle("mainBundle")
	, sel_mainFrame("mainFrame")
	, sel_mainMenu("mainMenu")
	, sel_mainRunLoop("mainRunLoop")
	, sel_mainScreen("mainScreen")
	, sel_mainWindow("mainWindow")
	, sel_makeCurrentContext("makeCurrentContext")
	, sel_makeFirstResponder_("makeFirstResponder:")
	, sel_makeKeyAndOrderFront_("makeKeyAndOrderFront:")
	, sel_markedRange("markedRange")
	, sel_markedTextAttributes("markedTextAttributes")
	, sel_maxValue("maxValue")
	, sel_maximum("maximum")
	, sel_maximumFractionDigits("maximumFractionDigits")
	, sel_maximumIntegerDigits("maximumIntegerDigits")
	, sel_menu("menu")
	, sel_menu_willHighlightItem_("menu:willHighlightItem:")
	, sel_menuBarFontOfSize_("menuBarFontOfSize:")
	, sel_menuDidClose_("menuDidClose:")
	, sel_menuFontOfSize_("menuFontOfSize:")
	, sel_menuForEvent_("menuForEvent:")
	, sel_menuNeedsUpdate_("menuNeedsUpdate:")
	, sel_menuWillOpen_("menuWillOpen:")
	, sel_metaKey("metaKey")
	, sel_minFrameWidthWithTitle_styleMask_("minFrameWidthWithTitle:styleMask:")
	, sel_minSize("minSize")
	, sel_minValue("minValue")
	, sel_miniaturize_("miniaturize:")
	, sel_minimum("minimum")
	, sel_minimumSize("minimumSize")
	, sel_minuteOfHour("minuteOfHour")
	, sel_modifierFlags("modifierFlags")
	, sel_monthOfYear("monthOfYear")
	, sel_mouse_inRect_("mouse:inRect:")
	, sel_mouseDown_("mouseDown:")
	, sel_mouseDownCanMoveWindow("mouseDownCanMoveWindow")
	, sel_mouseDragged_("mouseDragged:")
	, sel_mouseEntered_("mouseEntered:")
	, sel_mouseExited_("mouseExited:")
	, sel_mouseLocation("mouseLocation")
	, sel_mouseLocationOutsideOfEventStream("mouseLocationOutsideOfEventStream")
	, sel_mouseMoved_("mouseMoved:")
	, sel_mouseUp_("mouseUp:")
	, sel_moveColumn_toColumn_("moveColumn:toColumn:")
	, sel_moveToBeginningOfParagraph_("moveToBeginningOfParagraph:")
	, sel_moveToEndOfParagraph_("moveToEndOfParagraph:")
	, sel_moveToPoint_("moveToPoint:")
	, sel_moveUp_("moveUp:")
	, sel_mutableCopy("mutableCopy")
	, sel_mutableString("mutableString")
	, sel_name("name")
	, sel_needsPanelToBecomeKey("needsPanelToBecomeKey")
	, sel_nextEventMatchingMask_untilDate_inMode_dequeue_("nextEventMatchingMask:untilDate:inMode:dequeue:")
	, sel_nextObject("nextObject")
	, sel_nextState("nextState")
	, sel_nextWordFromIndex_forward_("nextWordFromIndex:forward:")
	, sel_noResponderFor_("noResponderFor:")
	, sel_normalizedPosition("normalizedPosition")
	, sel_noteNumberOfRowsChanged("noteNumberOfRowsChanged")
	, sel_numberOfColumns("numberOfColumns")
	, sel_numberOfComponents("numberOfComponents")
	, sel_numberOfGlyphs("numberOfGlyphs")
	, sel_numberOfItems("numberOfItems")
	, sel_numberOfPlanes("numberOfPlanes")
	, sel_numberOfRows("numberOfRows")
	, sel_numberOfRowsInTableView_("numberOfRowsInTableView:")
	, sel_numberOfSelectedRows("numberOfSelectedRows")
	, sel_numberOfVisibleItems("numberOfVisibleItems")
	, sel_numberWithBool_("numberWithBool:")
	, sel_numberWithDouble_("numberWithDouble:")
	, sel_numberWithInt_("numberWithInt:")
	, sel_numberWithInteger_("numberWithInteger:")
	, sel_objCType("objCType")
	, sel_object("object")
	, sel_objectAtIndex_("objectAtIndex:")
	, sel_objectEnumerator("objectEnumerator")
	, sel_objectForInfoDictionaryKey_("objectForInfoDictionaryKey:")
	, sel_objectForKey_("objectForKey:")
	, sel_objectValues("objectValues")
	, sel_openFile_withApplication_("openFile:withApplication:")
	, sel_openPanel("openPanel")
	, sel_openURL_("openURL:")
	, sel_openURLs_withAppBundleIdentifier_options_additionalEventParamDescriptor_launchIdentifiers_("openURLs:withAppBundleIdentifier:options:additionalEventParamDescriptor:launchIdentifiers:")
	, sel_operationNotAllowedCursor("operationNotAllowedCursor")
	, sel_options("options")
	, sel_orderBack_("orderBack:")
	, sel_orderFront_("orderFront:")
	, sel_orderFrontRegardless("orderFrontRegardless")
	, sel_orderFrontStandardAboutPanel_("orderFrontStandardAboutPanel:")
	, sel_orderOut_("orderOut:")
	, sel_orderWindow_relativeTo_("orderWindow:relativeTo:")
	, sel_orderedWindows("orderedWindows")
	, sel_otherEventWithType_location_modifierFlags_timestamp_windowNumber_context_subtype_data1_data2_("otherEventWithType:location:modifierFlags:timestamp:windowNumber:context:subtype:data1:data2:")
	, sel_otherMouseDown_("otherMouseDown:")
	, sel_otherMouseDragged_("otherMouseDragged:")
	, sel_otherMouseUp_("otherMouseUp:")
	, sel_outlineTableColumn("outlineTableColumn")
	, sel_outlineView_acceptDrop_item_childIndex_("outlineView:acceptDrop:item:childIndex:")
	, sel_outlineView_child_ofItem_("outlineView:child:ofItem:")
	, sel_outlineView_didClickTableColumn_("outlineView:didClickTableColumn:")
	, sel_outlineView_isItemExpandable_("outlineView:isItemExpandable:")
	, sel_outlineView_numberOfChildrenOfItem_("outlineView:numberOfChildrenOfItem:")
	, sel_outlineView_objectValueForTableColumn_byItem_("outlineView:objectValueForTableColumn:byItem:")
	, sel_outlineView_setObjectValue_forTableColumn_byItem_("outlineView:setObjectValue:forTableColumn:byItem:")
	, sel_outlineView_shouldCollapseItem_("outlineView:shouldCollapseItem:")
	, sel_outlineView_shouldEditTableColumn_item_("outlineView:shouldEditTableColumn:item:")
	, sel_outlineView_shouldExpandItem_("outlineView:shouldExpandItem:")
	, sel_outlineView_shouldReorderColumn_toColumn_("outlineView:shouldReorderColumn:toColumn:")
	, sel_outlineView_shouldSelectItem_("outlineView:shouldSelectItem:")
	, sel_outlineView_shouldTrackCell_forTableColumn_item_("outlineView:shouldTrackCell:forTableColumn:item:")
	, sel_outlineView_validateDrop_proposedItem_proposedChildIndex_("outlineView:validateDrop:proposedItem:proposedChildIndex:")
	, sel_outlineView_willDisplayCell_forTableColumn_item_("outlineView:willDisplayCell:forTableColumn:item:")
	, sel_outlineView_writeItems_toPasteboard_("outlineView:writeItems:toPasteboard:")
	, sel_outlineViewColumnDidMove_("outlineViewColumnDidMove:")
	, sel_outlineViewColumnDidResize_("outlineViewColumnDidResize:")
	, sel_outlineViewItemDidExpand_("outlineViewItemDidExpand:")
	, sel_outlineViewSelectionDidChange_("outlineViewSelectionDidChange:")
	, sel_outlineViewSelectionIsChanging_("outlineViewSelectionIsChanging:")
	, sel_owner("owner")
	, sel_pageDown_("pageDown:")
	, sel_pageTitle("pageTitle")
	, sel_pageUp_("pageUp:")
	, sel_panel_shouldShowFilename_("panel:shouldShowFilename:")
	, sel_panelConvertFont_("panelConvertFont:")
	, sel_paperSize("paperSize")
	, sel_paragraphs("paragraphs")
	, sel_parentWindow("parentWindow")
	, sel_password("password")
	, sel_paste_("paste:")
	, sel_pasteboard_provideDataForType_("pasteboard:provideDataForType:")
	, sel_pasteboardWithName_("pasteboardWithName:")
	, sel_path("path")
	, sel_pathExtension("pathExtension")
	, sel_pathForResource_ofType_("pathForResource:ofType:")
	, sel_pathForResource_ofType_inDirectory_forLocalization_("pathForResource:ofType:inDirectory:forLocalization:")
	, sel_performDragOperation_("performDragOperation:")
	, sel_performKeyEquivalent_("performKeyEquivalent:")
	, sel_performSelector_withObject_afterDelay_inModes_("performSelector:withObject:afterDelay:inModes:")
	, sel_performSelectorOnMainThread_withObject_waitUntilDone_("performSelectorOnMainThread:withObject:waitUntilDone:")
	, sel_phase("phase")
	, sel_pixelsHigh("pixelsHigh")
	, sel_pixelsWide("pixelsWide")
	, sel_pointSize("pointSize")
	, sel_pointValue("pointValue")
	, sel_pointingHandCursor("pointingHandCursor")
	, sel_pop("pop")
	, sel_popUpContextMenu_withEvent_forView_("popUpContextMenu:withEvent:forView:")
	, sel_popUpStatusItemMenu_("popUpStatusItemMenu:")
	, sel_port("port")
	, sel_postEvent_atStart_("postEvent:atStart:")
	, sel_preparedCellAtColumn_row_("preparedCellAtColumn:row:")
	, sel_prependTransform_("prependTransform:")
	, sel_preventDefault("preventDefault")
	, sel_previousFailureCount("previousFailureCount")
	, sel_printDocumentView("printDocumentView")
	, sel_printOperationWithPrintInfo_("printOperationWithPrintInfo:")
	, sel_printOperationWithView_printInfo_("printOperationWithView:printInfo:")
	, sel_printPanel("printPanel")
	, sel_printSettings("printSettings")
	, sel_printer("printer")
	, sel_printerNames("printerNames")
	, sel_printerWithName_("printerWithName:")
	, sel_propertyListForType_("propertyListForType:")
	, sel_proposedCredential("proposedCredential")
	, sel_protectionSpace("protectionSpace")
	, sel_push("push")
	, sel_rangeValue("rangeValue")
	, sel_readSelectionFromPasteboard_("readSelectionFromPasteboard:")
	, sel_realm("realm")
	, sel_recentSearches("recentSearches")
	, sel_rectArrayForCharacterRange_withinSelectedCharacterRange_inTextContainer_rectCount_("rectArrayForCharacterRange:withinSelectedCharacterRange:inTextContainer:rectCount:")
	, sel_rectArrayForGlyphRange_withinSelectedGlyphRange_inTextContainer_rectCount_("rectArrayForGlyphRange:withinSelectedGlyphRange:inTextContainer:rectCount:")
	, sel_rectForPart_("rectForPart:")
	, sel_rectOfColumn_("rectOfColumn:")
	, sel_rectOfRow_("rectOfRow:")
	, sel_rectValue("rectValue")
	, sel_redComponent("redComponent")
	, sel_redo("redo")
	, sel_reflectScrolledClipView_("reflectScrolledClipView:")
	, sel_registerForDraggedTypes_("registerForDraggedTypes:")
	, sel_release("release")
	, sel_reload_("reload:")
	, sel_reloadData("reloadData")
	, sel_reloadItem_reloadChildren_("reloadItem:reloadChildren:")
	, sel_removeAllItems("removeAllItems")
	, sel_removeAllPoints("removeAllPoints")
	, sel_removeAttribute_range_("removeAttribute:range:")
	, sel_removeChildWindow_("removeChildWindow:")
	, sel_removeColorWithKey_("removeColorWithKey:")
	, sel_removeFromSuperview("removeFromSuperview")
	, sel_removeIndex_("removeIndex:")
	, sel_removeItem_("removeItem:")
	, sel_removeItemAtIndex_("removeItemAtIndex:")
	, sel_removeItemAtPath_error_("removeItemAtPath:error:")
	, sel_removeLastObject("removeLastObject")
	, sel_removeObject_("removeObject:")
	, sel_removeObjectAtIndex_("removeObjectAtIndex:")
	, sel_removeObjectForKey_("removeObjectForKey:")
	, sel_removeObjectIdenticalTo_("removeObjectIdenticalTo:")
	, sel_removeObserver_("removeObserver:")
	, sel_removeObserver_name_object_("removeObserver:name:object:")
	, sel_removeRepresentation_("removeRepresentation:")
	, sel_removeStatusItem_("removeStatusItem:")
	, sel_removeTabViewItem_("removeTabViewItem:")
	, sel_removeTableColumn_("removeTableColumn:")
	, sel_removeTemporaryAttribute_forCharacterRange_("removeTemporaryAttribute:forCharacterRange:")
	, sel_removeToolTip_("removeToolTip:")
	, sel_removeTrackingArea_("removeTrackingArea:")
	, sel_replaceCharactersInRange_withString_("replaceCharactersInRange:withString:")
	, sel_replyToOpenOrPrint_("replyToOpenOrPrint:")
	, sel_representation("representation")
	, sel_representations("representations")
	, sel_request("request")
	, sel_requestWithURL_("requestWithURL:")
	, sel_resetCursorRects("resetCursorRects")
	, sel_resignFirstResponder("resignFirstResponder")
	, sel_resizeDownCursor("resizeDownCursor")
	, sel_resizeLeftCursor("resizeLeftCursor")
	, sel_resizeLeftRightCursor("resizeLeftRightCursor")
	, sel_resizeRightCursor("resizeRightCursor")
	, sel_resizeUpCursor("resizeUpCursor")
	, sel_resizeUpDownCursor("resizeUpDownCursor")
	, sel_resizingMask("resizingMask")
	, sel_resourcePath("resourcePath")
	, sel_respondsToSelector_("respondsToSelector:")
	, sel_restoreGraphicsState("restoreGraphicsState")
	, sel_retain("retain")
	, sel_retainCount("retainCount")
	, sel_rightMouseDown_("rightMouseDown:")
	, sel_rightMouseDragged_("rightMouseDragged:")
	, sel_rightMouseUp_("rightMouseUp:")
	, sel_rotateByDegrees_("rotateByDegrees:")
	, sel_rotateWithEvent_("rotateWithEvent:")
	, sel_rotation("rotation")
	, sel_rowAtPoint_("rowAtPoint:")
	, sel_rowForItem_("rowForItem:")
	, sel_rowHeight("rowHeight")
	, sel_rowsInRect_("rowsInRect:")
	, sel_run("run")
	, sel_runModal("runModal")
	, sel_runModalForDirectory_file_("runModalForDirectory:file:")
	, sel_runModalForWindow_("runModalForWindow:")
	, sel_runModalWithPrintInfo_("runModalWithPrintInfo:")
	, sel_runMode_beforeDate_("runMode:beforeDate:")
	, sel_runOperation("runOperation")
	, sel_samplesPerPixel("samplesPerPixel")
	, sel_saveGraphicsState("saveGraphicsState")
	, sel_savePanel("savePanel")
	, sel_scaleXBy_yBy_("scaleXBy:yBy:")
	, sel_scheduledTimerWithTimeInterval_target_selector_userInfo_repeats_("scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:")
	, sel_screen("screen")
	, sel_screenX("screenX")
	, sel_screenY("screenY")
	, sel_screens("screens")
	, sel_scrollClipView_toPoint_("scrollClipView:toPoint:")
	, sel_scrollColumnToVisible_("scrollColumnToVisible:")
	, sel_scrollPoint_("scrollPoint:")
	, sel_scrollRangeToVisible_("scrollRangeToVisible:")
	, sel_scrollRect_by_("scrollRect:by:")
	, sel_scrollRectToVisible_("scrollRectToVisible:")
	, sel_scrollRowToVisible_("scrollRowToVisible:")
	, sel_scrollToPoint_("scrollToPoint:")
	, sel_scrollWheel_("scrollWheel:")
	, sel_scrollerWidth("scrollerWidth")
	, sel_scrollerWidthForControlSize_("scrollerWidthForControlSize:")
	, sel_searchButtonCell("searchButtonCell")
	, sel_searchButtonRectForBounds_("searchButtonRectForBounds:")
	, sel_searchTextRectForBounds_("searchTextRectForBounds:")
	, sel_secondOfMinute("secondOfMinute")
	, sel_secondarySelectedControlColor("secondarySelectedControlColor")
	, sel_selectAll_("selectAll:")
	, sel_selectItem_("selectItem:")
	, sel_selectItemAtIndex_("selectItemAtIndex:")
	, sel_selectRowIndexes_byExtendingSelection_("selectRowIndexes:byExtendingSelection:")
	, sel_selectTabViewItemAtIndex_("selectTabViewItemAtIndex:")
	, sel_selectText_("selectText:")
	, sel_selectedControlColor("selectedControlColor")
	, sel_selectedControlTextColor("selectedControlTextColor")
	, sel_selectedRange("selectedRange")
	, sel_selectedRow("selectedRow")
	, sel_selectedRowIndexes("selectedRowIndexes")
	, sel_selectedTabViewItem("selectedTabViewItem")
	, sel_selectedTextAttributes("selectedTextAttributes")
	, sel_selectedTextBackgroundColor("selectedTextBackgroundColor")
	, sel_selectedTextColor("selectedTextColor")
	, sel_sendAction_to_("sendAction:to:")
	, sel_sendAction_to_from_("sendAction:to:from:")
	, sel_sendEvent_("sendEvent:")
	, sel_sender("sender")
	, sel_separatorItem("separatorItem")
	, sel_set("set")
	, sel_setAcceptsMouseMovedEvents_("setAcceptsMouseMovedEvents:")
	, sel_setAcceptsTouchEvents_("setAcceptsTouchEvents:")
	, sel_setAccessoryView_("setAccessoryView:")
	, sel_setAction_("setAction:")
	, sel_setActivationPolicy_("setActivationPolicy:")
	, sel_setAlertStyle_("setAlertStyle:")
	, sel_setAlignment_("setAlignment:")
	, sel_setAllowedFileTypes_("setAllowedFileTypes:")
	, sel_setAllowsColumnReordering_("setAllowsColumnReordering:")
	, sel_setAllowsFloats_("setAllowsFloats:")
	, sel_setAllowsMixedState_("setAllowsMixedState:")
	, sel_setAllowsMultipleSelection_("setAllowsMultipleSelection:")
	, sel_setAllowsOtherFileTypes_("setAllowsOtherFileTypes:")
	, sel_setAllowsUndo_("setAllowsUndo:")
	, sel_setAllowsUserCustomization_("setAllowsUserCustomization:")
	, sel_setAlpha_("setAlpha:")
	, sel_setAlphaValue_("setAlphaValue:")
	, sel_setAlternateButtonTitle_("setAlternateButtonTitle:")
	, sel_setApplicationIconImage_("setApplicationIconImage:")
	, sel_setApplicationNameForUserAgent_("setApplicationNameForUserAgent:")
	, sel_setAttachmentCell_("setAttachmentCell:")
	, sel_setAttributedString_("setAttributedString:")
	, sel_setAttributedStringValue_("setAttributedStringValue:")
	, sel_setAttributedTitle_("setAttributedTitle:")
	, sel_setAutoenablesItems_("setAutoenablesItems:")
	, sel_setAutohidesScrollers_("setAutohidesScrollers:")
	, sel_setAutoresizesOutlineColumn_("setAutoresizesOutlineColumn:")
	, sel_setAutoresizesSubviews_("setAutoresizesSubviews:")
	, sel_setAutoresizingMask_("setAutoresizingMask:")
	, sel_setAutosaveExpandedItems_("setAutosaveExpandedItems:")
	, sel_setBackgroundColor_("setBackgroundColor:")
	, sel_setBackgroundLayoutEnabled_("setBackgroundLayoutEnabled:")
	, sel_setBackgroundStyle_("setBackgroundStyle:")
	, sel_setBadgeLabel_("setBadgeLabel:")
	, sel_setBaseWritingDirection_("setBaseWritingDirection:")
	, sel_setBaseWritingDirection_range_("setBaseWritingDirection:range:")
	, sel_setBecomesKeyOnlyIfNeeded_("setBecomesKeyOnlyIfNeeded:")
	, sel_setBezelStyle_("setBezelStyle:")
	, sel_setBezeled_("setBezeled:")
	, sel_setBorderType_("setBorderType:")
	, sel_setBorderWidth_("setBorderWidth:")
	, sel_setBordered_("setBordered:")
	, sel_setBoundsRotation_("setBoundsRotation:")
	, sel_setBoxType_("setBoxType:")
	, sel_setButtonType_("setButtonType:")
	, sel_setCacheMode_("setCacheMode:")
	, sel_setCachePolicy_("setCachePolicy:")
	, sel_setCanChooseDirectories_("setCanChooseDirectories:")
	, sel_setCanChooseFiles_("setCanChooseFiles:")
	, sel_setCanCreateDirectories_("setCanCreateDirectories:")
	, sel_setCancelButtonCell_("setCancelButtonCell:")
	, sel_setCell_("setCell:")
	, sel_setCellClass_("setCellClass:")
	, sel_setClip("setClip")
	, sel_setCollectionBehavior_("setCollectionBehavior:")
	, sel_setColor_("setColor:")
	, sel_setColumnAutoresizingStyle_("setColumnAutoresizingStyle:")
	, sel_setCompositingOperation_("setCompositingOperation:")
	, sel_setContainerSize_("setContainerSize:")
	, sel_setContentView_("setContentView:")
	, sel_setContentViewMargins_("setContentViewMargins:")
	, sel_setControlSize_("setControlSize:")
	, sel_setCookie_("setCookie:")
	, sel_setCopiesOnScroll_("setCopiesOnScroll:")
	, sel_setCurrentContext_("setCurrentContext:")
	, sel_setCurrentOperation_("setCurrentOperation:")
	, sel_setCustomUserAgent_("setCustomUserAgent:")
	, sel_setData_forType_("setData:forType:")
	, sel_setDataCell_("setDataCell:")
	, sel_setDataSource_("setDataSource:")
	, sel_setDatePickerElements_("setDatePickerElements:")
	, sel_setDatePickerStyle_("setDatePickerStyle:")
	, sel_setDateValue_("setDateValue:")
	, sel_setDefaultButtonCell_("setDefaultButtonCell:")
	, sel_setDefaultFlatness_("setDefaultFlatness:")
	, sel_setDefaultParagraphStyle_("setDefaultParagraphStyle:")
	, sel_setDefaultTabInterval_("setDefaultTabInterval:")
	, sel_setDelegate_("setDelegate:")
	, sel_setDestination_allowOverwrite_("setDestination:allowOverwrite:")
	, sel_setDictionary_("setDictionary:")
	, sel_setDirectory_("setDirectory:")
	, sel_setDirectoryURL_("setDirectoryURL:")
	, sel_setDisplayMode_("setDisplayMode:")
	, sel_setDisplaysLinkToolTips_("setDisplaysLinkToolTips:")
	, sel_setDocumentCursor_("setDocumentCursor:")
	, sel_setDocumentEdited_("setDocumentEdited:")
	, sel_setDocumentView_("setDocumentView:")
	, sel_setDoubleAction_("setDoubleAction:")
	, sel_setDoubleValue_("setDoubleValue:")
	, sel_setDownloadDelegate_("setDownloadDelegate:")
	, sel_setDrawsBackground_("setDrawsBackground:")
	, sel_setDropItem_dropChildIndex_("setDropItem:dropChildIndex:")
	, sel_setDropRow_dropOperation_("setDropRow:dropOperation:")
	, sel_setEditable_("setEditable:")
	, sel_setEnabled_("setEnabled:")
	, sel_setEnabled_forSegment_("setEnabled:forSegment:")
	, sel_setFill("setFill")
	, sel_setFillColor_("setFillColor:")
	, sel_setFireDate_("setFireDate:")
	, sel_setFirstLineHeadIndent_("setFirstLineHeadIndent:")
	, sel_setFloatingPanel_("setFloatingPanel:")
	, sel_setFocusRingType_("setFocusRingType:")
	, sel_setFont_("setFont:")
	, sel_setFormatter_("setFormatter:")
	, sel_setFrame_("setFrame:")
	, sel_setFrame_display_("setFrame:display:")
	, sel_setFrame_display_animate_("setFrame:display:animate:")
	, sel_setFrameFromContentFrame_("setFrameFromContentFrame:")
	, sel_setFrameLoadDelegate_("setFrameLoadDelegate:")
	, sel_setFrameOrigin_("setFrameOrigin:")
	, sel_setFrameSize_("setFrameSize:")
	, sel_setGridStyleMask_("setGridStyleMask:")
	, sel_setHTTPBody_("setHTTPBody:")
	, sel_setHTTPMethod_("setHTTPMethod:")
	, sel_setHasHorizontalScroller_("setHasHorizontalScroller:")
	, sel_setHasShadow_("setHasShadow:")
	, sel_setHasVerticalScroller_("setHasVerticalScroller:")
	, sel_setHeadIndent_("setHeadIndent:")
	, sel_setHeaderCell_("setHeaderCell:")
	, sel_setHeaderView_("setHeaderView:")
	, sel_setHelpMenu_("setHelpMenu:")
	, sel_setHidden_("setHidden:")
	, sel_setHiddenUntilMouseMoves_("setHiddenUntilMouseMoves:")
	, sel_setHidesOnDeactivate_("setHidesOnDeactivate:")
	, sel_setHighlightMode_("setHighlightMode:")
	, sel_setHighlighted_("setHighlighted:")
	, sel_setHighlightedTableColumn_("setHighlightedTableColumn:")
	, sel_setHighlightsBy_("setHighlightsBy:")
	, sel_setHorizontalScroller_("setHorizontalScroller:")
	, sel_setHorizontallyResizable_("setHorizontallyResizable:")
	, sel_setIcon_("setIcon:")
	, sel_setIdentifier_("setIdentifier:")
	, sel_setImage_("setImage:")
	, sel_setImage_forSegment_("setImage:forSegment:")
	, sel_setImageAlignment_("setImageAlignment:")
	, sel_setImageInterpolation_("setImageInterpolation:")
	, sel_setImagePosition_("setImagePosition:")
	, sel_setImageScaling_("setImageScaling:")
	, sel_setIncrement_("setIncrement:")
	, sel_setIndeterminate_("setIndeterminate:")
	, sel_setIndicatorImage_inTableColumn_("setIndicatorImage:inTableColumn:")
	, sel_setInteger_forKey_("setInteger:forKey:")
	, sel_setIntercellSpacing_("setIntercellSpacing:")
	, sel_setJavaEnabled_("setJavaEnabled:")
	, sel_setJavaScriptEnabled_("setJavaScriptEnabled:")
	, sel_setJobDisposition_("setJobDisposition:")
	, sel_setJobTitle_("setJobTitle:")
	, sel_setKeyEquivalent_("setKeyEquivalent:")
	, sel_setKeyEquivalentModifierMask_("setKeyEquivalentModifierMask:")
	, sel_setKnobProportion_("setKnobProportion:")
	, sel_setLabel_("setLabel:")
	, sel_setLabel_forSegment_("setLabel:forSegment:")
	, sel_setLeaf_("setLeaf:")
	, sel_setLength_("setLength:")
	, sel_setLevel_("setLevel:")
	, sel_setLineBreakMode_("setLineBreakMode:")
	, sel_setLineCapStyle_("setLineCapStyle:")
	, sel_setLineDash_count_phase_("setLineDash:count:phase:")
	, sel_setLineFragmentPadding_("setLineFragmentPadding:")
	, sel_setLineFragmentRect_forGlyphRange_usedRect_("setLineFragmentRect:forGlyphRange:usedRect:")
	, sel_setLineJoinStyle_("setLineJoinStyle:")
	, sel_setLineSpacing_("setLineSpacing:")
	, sel_setLineWidth_("setLineWidth:")
	, sel_setLinkTextAttributes_("setLinkTextAttributes:")
	, sel_setMainMenu_("setMainMenu:")
	, sel_setMarkedText_selectedRange_("setMarkedText:selectedRange:")
	, sel_setMaxSize_("setMaxSize:")
	, sel_setMaxValue_("setMaxValue:")
	, sel_setMaximum_("setMaximum:")
	, sel_setMaximumFractionDigits_("setMaximumFractionDigits:")
	, sel_setMaximumIntegerDigits_("setMaximumIntegerDigits:")
	, sel_setMenu_("setMenu:")
	, sel_setMenu_forSegment_("setMenu:forSegment:")
	, sel_setMenuFormRepresentation_("setMenuFormRepresentation:")
	, sel_setMessage_("setMessage:")
	, sel_setMessageText_("setMessageText:")
	, sel_setMinSize_("setMinSize:")
	, sel_setMinValue_("setMinValue:")
	, sel_setMinWidth_("setMinWidth:")
	, sel_setMinimum_("setMinimum:")
	, sel_setMinimumFractionDigits_("setMinimumFractionDigits:")
	, sel_setMinimumIntegerDigits_("setMinimumIntegerDigits:")
	, sel_setMiterLimit_("setMiterLimit:")
	, sel_setMovable_("setMovable:")
	, sel_setNameFieldStringValue_("setNameFieldStringValue:")
	, sel_setNeedsDisplay_("setNeedsDisplay:")
	, sel_setNeedsDisplayInRect_("setNeedsDisplayInRect:")
	, sel_setNumberOfVisibleItems_("setNumberOfVisibleItems:")
	, sel_setNumberStyle_("setNumberStyle:")
	, sel_setObject_forKey_("setObject:forKey:")
	, sel_setObjectValue_("setObjectValue:")
	, sel_setOnMouseEntered_("setOnMouseEntered:")
	, sel_setOpaque_("setOpaque:")
	, sel_setOptions_("setOptions:")
	, sel_setOutlineTableColumn_("setOutlineTableColumn:")
	, sel_setPaletteLabel_("setPaletteLabel:")
	, sel_setPanelFont_isMultiple_("setPanelFont:isMultiple:")
	, sel_setPartialStringValidationEnabled_("setPartialStringValidationEnabled:")
	, sel_setPatternPhase_("setPatternPhase:")
	, sel_setPlaceholderString_("setPlaceholderString:")
	, sel_setPolicyDelegate_("setPolicyDelegate:")
	, sel_setPreferences_("setPreferences:")
	, sel_setPrinter_("setPrinter:")
	, sel_setPropertyList_forType_("setPropertyList:forType:")
	, sel_setPullsDown_("setPullsDown:")
	, sel_setReleasedWhenClosed_("setReleasedWhenClosed:")
	, sel_setRepresentedFilename_("setRepresentedFilename:")
	, sel_setRepresentedURL_("setRepresentedURL:")
	, sel_setResizingMask_("setResizingMask:")
	, sel_setResourceLoadDelegate_("setResourceLoadDelegate:")
	, sel_setRichText_("setRichText:")
	, sel_setRowHeight_("setRowHeight:")
	, sel_setScalesWhenResized_("setScalesWhenResized:")
	, sel_setScrollable_("setScrollable:")
	, sel_setSearchButtonCell_("setSearchButtonCell:")
	, sel_setSegmentCount_("setSegmentCount:")
	, sel_setSegmentStyle_("setSegmentStyle:")
	, sel_setSelectable_("setSelectable:")
	, sel_setSelected_forSegment_("setSelected:forSegment:")
	, sel_setSelectedItemIdentifier_("setSelectedItemIdentifier:")
	, sel_setSelectedRange_("setSelectedRange:")
	, sel_setSelectedSegment_("setSelectedSegment:")
	, sel_setSelectedTextAttributes_("setSelectedTextAttributes:")
	, sel_setSelectionOnly_("setSelectionOnly:")
	, sel_setServicesMenu_("setServicesMenu:")
	, sel_setShouldAntialias_("setShouldAntialias:")
	, sel_setShowsHelp_("setShowsHelp:")
	, sel_setShowsPrintPanel_("setShowsPrintPanel:")
	, sel_setShowsProgressPanel_("setShowsProgressPanel:")
	, sel_setShowsResizeIndicator_("setShowsResizeIndicator:")
	, sel_setShowsToolbarButton_("setShowsToolbarButton:")
	, sel_setSize_("setSize:")
	, sel_setState_("setState:")
	, sel_setString_("setString:")
	, sel_setString_forType_("setString:forType:")
	, sel_setStringValue_("setStringValue:")
	, sel_setStroke("setStroke")
	, sel_setSubmenu_("setSubmenu:")
	, sel_setSubmenu_forItem_("setSubmenu:forItem:")
	, sel_setTabStops_("setTabStops:")
	, sel_setTabViewType_("setTabViewType:")
	, sel_setTag_("setTag:")
	, sel_setTag_forSegment_("setTag:forSegment:")
	, sel_setTarget_("setTarget:")
	, sel_setTextColor_("setTextColor:")
	, sel_setTextStorage_("setTextStorage:")
	, sel_setTitle_("setTitle:")
	, sel_setTitleFont_("setTitleFont:")
	, sel_setTitlePosition_("setTitlePosition:")
	, sel_setToolTip_("setToolTip:")
	, sel_setToolTip_forSegment_("setToolTip:forSegment:")
	, sel_setToolbar_("setToolbar:")
	, sel_setTrackingMode_("setTrackingMode:")
	, sel_setTransformStruct_("setTransformStruct:")
	, sel_setTreatsFilePackagesAsDirectories_("setTreatsFilePackagesAsDirectories:")
	, sel_setUIDelegate_("setUIDelegate:")
	, sel_setURL_("setURL:")
	, sel_setUpPrintOperationDefaultValues("setUpPrintOperationDefaultValues")
	, sel_setUsesAlternatingRowBackgroundColors_("setUsesAlternatingRowBackgroundColors:")
	, sel_setUsesFontPanel_("setUsesFontPanel:")
	, sel_setUsesScreenFonts_("setUsesScreenFonts:")
	, sel_setUsesSingleLineMode_("setUsesSingleLineMode:")
	, sel_setUsesThreadedAnimation_("setUsesThreadedAnimation:")
	, sel_setValue_forHTTPHeaderField_("setValue:forHTTPHeaderField:")
	, sel_setValue_forKey_("setValue:forKey:")
	, sel_setValueWraps_("setValueWraps:")
	, sel_setValues_forParameter_("setValues:forParameter:")
	, sel_setVerticalScrollElasticity_("setVerticalScrollElasticity:")
	, sel_setVerticalScroller_("setVerticalScroller:")
	, sel_setView_("setView:")
	, sel_setVisible_("setVisible:")
	, sel_setWantsRestingTouches_("setWantsRestingTouches:")
	, sel_setWidth_("setWidth:")
	, sel_setWidth_forSegment_("setWidth:forSegment:")
	, sel_setWidthTracksTextView_("setWidthTracksTextView:")
	, sel_setWindingRule_("setWindingRule:")
	, sel_setWorksWhenModal_("setWorksWhenModal:")
	, sel_setWraps_("setWraps:")
	, sel_sharedApplication("sharedApplication")
	, sel_sharedCertificateTrustPanel("sharedCertificateTrustPanel")
	, sel_sharedColorPanel("sharedColorPanel")
	, sel_sharedFontManager("sharedFontManager")
	, sel_sharedFontPanel("sharedFontPanel")
	, sel_sharedHTTPCookieStorage("sharedHTTPCookieStorage")
	, sel_sharedPrintInfo("sharedPrintInfo")
	, sel_sharedWorkspace("sharedWorkspace")
	, sel_shiftKey("shiftKey")
	, sel_shouldAntialias("shouldAntialias")
	, sel_shouldChangeTextInRange_replacementString_("shouldChangeTextInRange:replacementString:")
	, sel_shouldDelayWindowOrderingForEvent_("shouldDelayWindowOrderingForEvent:")
	, sel_shouldDrawInsertionPoint("shouldDrawInsertionPoint")
	, sel_size("size")
	, sel_sizeOfLabel_("sizeOfLabel:")
	, sel_sizeToFit("sizeToFit")
	, sel_sizeValue("sizeValue")
	, sel_skipDescendents("skipDescendents")
	, sel_smallSystemFontSize("smallSystemFontSize")
	, sel_sortIndicatorRectForBounds_("sortIndicatorRectForBounds:")
	, sel_standardPreferences("standardPreferences")
	, sel_standardUserDefaults("standardUserDefaults")
	, sel_standardWindowButton_("standardWindowButton:")
	, sel_startAnimation_("startAnimation:")
	, sel_state("state")
	, sel_statusItemWithLength_("statusItemWithLength:")
	, sel_stop_("stop:")
	, sel_stopAnimation_("stopAnimation:")
	, sel_stopLoading_("stopLoading:")
	, sel_stopModal("stopModal")
	, sel_string("string")
	, sel_stringByAddingPercentEscapesUsingEncoding_("stringByAddingPercentEscapesUsingEncoding:")
	, sel_stringByAppendingPathComponent_("stringByAppendingPathComponent:")
	, sel_stringByAppendingPathExtension_("stringByAppendingPathExtension:")
	, sel_stringByAppendingString_("stringByAppendingString:")
	, sel_stringByDeletingLastPathComponent("stringByDeletingLastPathComponent")
	, sel_stringByDeletingPathExtension("stringByDeletingPathExtension")
	, sel_stringByReplacingOccurrencesOfString_withString_("stringByReplacingOccurrencesOfString:withString:")
	, sel_stringByReplacingPercentEscapesUsingEncoding_("stringByReplacingPercentEscapesUsingEncoding:")
	, sel_stringForKey_("stringForKey:")
	, sel_stringForObjectValue_("stringForObjectValue:")
	, sel_stringForType_("stringForType:")
	, sel_stringValue("stringValue")
	, sel_stringWithCharacters_length_("stringWithCharacters:length:")
	, sel_stringWithFormat_("stringWithFormat:")
	, sel_stringWithUTF8String_("stringWithUTF8String:")
	, sel_stroke("stroke")
	, sel_strokeRect_("strokeRect:")
	, sel_styleMask("styleMask")
	, sel_submenu("submenu")
	, sel_subviews("subviews")
	, sel_superclass("superclass")
	, sel_superview("superview")
	, sel_swipeWithEvent_("swipeWithEvent:")
	, sel_systemFontOfSize_("systemFontOfSize:")
	, sel_systemFontSize("systemFontSize")
	, sel_systemFontSizeForControlSize_("systemFontSizeForControlSize:")
	, sel_systemStatusBar("systemStatusBar")
	, sel_systemVersion("systemVersion")
	, sel_tabStopType("tabStopType")
	, sel_tabStops("tabStops")
	, sel_tabView_didSelectTabViewItem_("tabView:didSelectTabViewItem:")
	, sel_tabView_shouldSelectTabViewItem_("tabView:shouldSelectTabViewItem:")
	, sel_tabView_willSelectTabViewItem_("tabView:willSelectTabViewItem:")
	, sel_tabViewItemAtPoint_("tabViewItemAtPoint:")
	, sel_tableColumns("tableColumns")
	, sel_tableView_acceptDrop_row_dropOperation_("tableView:acceptDrop:row:dropOperation:")
	, sel_tableView_didClickTableColumn_("tableView:didClickTableColumn:")
	, sel_tableView_objectValueForTableColumn_row_("tableView:objectValueForTableColumn:row:")
	, sel_tableView_setObjectValue_forTableColumn_row_("tableView:setObjectValue:forTableColumn:row:")
	, sel_tableView_shouldEditTableColumn_row_("tableView:shouldEditTableColumn:row:")
	, sel_tableView_shouldReorderColumn_toColumn_("tableView:shouldReorderColumn:toColumn:")
	, sel_tableView_shouldSelectRow_("tableView:shouldSelectRow:")
	, sel_tableView_shouldTrackCell_forTableColumn_row_("tableView:shouldTrackCell:forTableColumn:row:")
	, sel_tableView_validateDrop_proposedRow_proposedDropOperation_("tableView:validateDrop:proposedRow:proposedDropOperation:")
	, sel_tableView_willDisplayCell_forTableColumn_row_("tableView:willDisplayCell:forTableColumn:row:")
	, sel_tableView_writeRowsWithIndexes_toPasteboard_("tableView:writeRowsWithIndexes:toPasteboard:")
	, sel_tableViewColumnDidMove_("tableViewColumnDidMove:")
	, sel_tableViewColumnDidResize_("tableViewColumnDidResize:")
	, sel_tableViewSelectionDidChange_("tableViewSelectionDidChange:")
	, sel_tableViewSelectionIsChanging_("tableViewSelectionIsChanging:")
	, sel_tag("tag")
	, sel_target("target")
	, sel_terminate_("terminate:")
	, sel_testPart_("testPart:")
	, sel_textBackgroundColor("textBackgroundColor")
	, sel_textColor("textColor")
	, sel_textContainer("textContainer")
	, sel_textDidChange_("textDidChange:")
	, sel_textDidEndEditing_("textDidEndEditing:")
	, sel_textStorage("textStorage")
	, sel_textView_clickedOnLink_atIndex_("textView:clickedOnLink:atIndex:")
	, sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_("textView:willChangeSelectionFromCharacterRange:toCharacterRange:")
	, sel_textViewDidChangeSelection_("textViewDidChangeSelection:")
	, sel_thickness("thickness")
	, sel_threadDictionary("threadDictionary")
	, sel_tile("tile")
	, sel_timeZone("timeZone")
	, sel_timestamp("timestamp")
	, sel_title("title")
	, sel_titleCell("titleCell")
	, sel_titleFont("titleFont")
	, sel_titleOfSelectedItem("titleOfSelectedItem")
	, sel_titleRectForBounds_("titleRectForBounds:")
	, sel_toggleToolbarShown_("toggleToolbarShown:")
	, sel_toolbar("toolbar")
	, sel_toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar_("toolbar:itemForItemIdentifier:willBeInsertedIntoToolbar:")
	, sel_toolbarAllowedItemIdentifiers_("toolbarAllowedItemIdentifiers:")
	, sel_toolbarDefaultItemIdentifiers_("toolbarDefaultItemIdentifiers:")
	, sel_toolbarDidRemoveItem_("toolbarDidRemoveItem:")
	, sel_toolbarSelectableItemIdentifiers_("toolbarSelectableItemIdentifiers:")
	, sel_toolbarWillAddItem_("toolbarWillAddItem:")
	, sel_touchesBeganWithEvent_("touchesBeganWithEvent:")
	, sel_touchesCancelledWithEvent_("touchesCancelledWithEvent:")
	, sel_touchesEndedWithEvent_("touchesEndedWithEvent:")
	, sel_touchesMatchingPhase_inView_("touchesMatchingPhase:inView:")
	, sel_touchesMovedWithEvent_("touchesMovedWithEvent:")
	, sel_trackingAreas("trackingAreas")
	, sel_traitsOfFont_("traitsOfFont:")
	, sel_transform("transform")
	, sel_transformPoint_("transformPoint:")
	, sel_transformSize_("transformSize:")
	, sel_transformStruct("transformStruct")
	, sel_transformUsingAffineTransform_("transformUsingAffineTransform:")
	, sel_translateXBy_yBy_("translateXBy:yBy:")
	, sel_type("type")
	, sel_type_conformsToType_("type:conformsToType:")
	, sel_typeOfFile_error_("typeOfFile:error:")
	, sel_types("types")
	, sel_typesetter("typesetter")
	, sel_unarchiveObjectWithData_("unarchiveObjectWithData:")
	, sel_undefined("undefined")
	, sel_undo("undo")
	, sel_undoManager("undoManager")
	, sel_unhideAllApplications_("unhideAllApplications:")
	, sel_unlockFocus("unlockFocus")
	, sel_unmarkText("unmarkText")
	, sel_unregisterDraggedTypes("unregisterDraggedTypes")
	, sel_update("update")
	, sel_updateFromPMPrintSettings("updateFromPMPrintSettings")
	, sel_updateTrackingAreas("updateTrackingAreas")
	, sel_use("use")
	, sel_useCredential_forAuthenticationChallenge_("useCredential:forAuthenticationChallenge:")
	, sel_usedRectForTextContainer_("usedRectForTextContainer:")
	, sel_user("user")
	, sel_userInfo("userInfo")
	, sel_usesAlternatingRowBackgroundColors("usesAlternatingRowBackgroundColors")
	, sel_validAttributesForMarkedText("validAttributesForMarkedText")
	, sel_validModesForFontPanel_("validModesForFontPanel:")
	, sel_validRequestorForSendType_returnType_("validRequestorForSendType:returnType:")
	, sel_validateMenuItem_("validateMenuItem:")
	, sel_validateVisibleColumns("validateVisibleColumns")
	, sel_value("value")
	, sel_valueForKey_("valueForKey:")
	, sel_valueWithPoint_("valueWithPoint:")
	, sel_valueWithRange_("valueWithRange:")
	, sel_valueWithRect_("valueWithRect:")
	, sel_valueWithSize_("valueWithSize:")
	, sel_view("view")
	, sel_view_stringForToolTip_point_userData_("view:stringForToolTip:point:userData:")
	, sel_viewDidMoveToWindow("viewDidMoveToWindow")
	, sel_viewWillMoveToWindow_("viewWillMoveToWindow:")
	, sel_visibleFrame("visibleFrame")
	, sel_visibleRect("visibleRect")
	, sel_wantsPeriodicDraggingUpdates("wantsPeriodicDraggingUpdates")
	, sel_wantsToHandleMouseEvents("wantsToHandleMouseEvents")
	, sel_webFrame("webFrame")
	, sel_webScriptValueAtIndex_("webScriptValueAtIndex:")
	, sel_webView_contextMenuItemsForElement_defaultMenuItems_("webView:contextMenuItemsForElement:defaultMenuItems:")
	, sel_webView_createWebViewWithRequest_("webView:createWebViewWithRequest:")
	, sel_webView_decidePolicyForMIMEType_request_frame_decisionListener_("webView:decidePolicyForMIMEType:request:frame:decisionListener:")
	, sel_webView_decidePolicyForNavigationAction_request_frame_decisionListener_("webView:decidePolicyForNavigationAction:request:frame:decisionListener:")
	, sel_webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener_("webView:decidePolicyForNewWindowAction:request:newFrameName:decisionListener:")
	, sel_webView_didChangeLocationWithinPageForFrame_("webView:didChangeLocationWithinPageForFrame:")
	, sel_webView_didCommitLoadForFrame_("webView:didCommitLoadForFrame:")
	, sel_webView_didFailProvisionalLoadWithError_forFrame_("webView:didFailProvisionalLoadWithError:forFrame:")
	, sel_webView_didFinishLoadForFrame_("webView:didFinishLoadForFrame:")
	, sel_webView_didReceiveTitle_forFrame_("webView:didReceiveTitle:forFrame:")
	, sel_webView_didStartProvisionalLoadForFrame_("webView:didStartProvisionalLoadForFrame:")
	, sel_webView_identifierForInitialRequest_fromDataSource_("webView:identifierForInitialRequest:fromDataSource:")
	, sel_webView_mouseDidMoveOverElement_modifierFlags_("webView:mouseDidMoveOverElement:modifierFlags:")
	, sel_webView_printFrameView_("webView:printFrameView:")
	, sel_webView_resource_didFailLoadingWithError_fromDataSource_("webView:resource:didFailLoadingWithError:fromDataSource:")
	, sel_webView_resource_didFinishLoadingFromDataSource_("webView:resource:didFinishLoadingFromDataSource:")
	, sel_webView_resource_didReceiveAuthenticationChallenge_fromDataSource_("webView:resource:didReceiveAuthenticationChallenge:fromDataSource:")
	, sel_webView_resource_willSendRequest_redirectResponse_fromDataSource_("webView:resource:willSendRequest:redirectResponse:fromDataSource:")
	, sel_webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame_("webView:runBeforeUnloadConfirmPanelWithMessage:initiatedByFrame:")
	, sel_webView_runJavaScriptAlertPanelWithMessage_("webView:runJavaScriptAlertPanelWithMessage:")
	, sel_webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_("webView:runJavaScriptAlertPanelWithMessage:initiatedByFrame:")
	, sel_webView_runJavaScriptConfirmPanelWithMessage_("webView:runJavaScriptConfirmPanelWithMessage:")
	, sel_webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_("webView:runJavaScriptConfirmPanelWithMessage:initiatedByFrame:")
	, sel_webView_runOpenPanelForFileButtonWithResultListener_("webView:runOpenPanelForFileButtonWithResultListener:")
	, sel_webView_setFrame_("webView:setFrame:")
	, sel_webView_setResizable_("webView:setResizable:")
	, sel_webView_setStatusBarVisible_("webView:setStatusBarVisible:")
	, sel_webView_setStatusText_("webView:setStatusText:")
	, sel_webView_setToolbarsVisible_("webView:setToolbarsVisible:")
	, sel_webView_unableToImplementPolicyWithError_frame_("webView:unableToImplementPolicyWithError:frame:")
	, sel_webView_windowScriptObjectAvailable_("webView:windowScriptObjectAvailable:")
	, sel_webViewClose_("webViewClose:")
	, sel_webViewFocus_("webViewFocus:")
	, sel_webViewShow_("webViewShow:")
	, sel_webViewUnfocus_("webViewUnfocus:")
	, sel_weightOfFont_("weightOfFont:")
	, sel_wheelDelta("wheelDelta")
	, sel_wheelDeltaX("wheelDeltaX")
	, sel_wheelDeltaY("wheelDeltaY")
	, sel_width("width")
	, sel_window("window")
	, sel_windowBackgroundColor("windowBackgroundColor")
	, sel_windowDidBecomeKey_("windowDidBecomeKey:")
	, sel_windowDidDeminiaturize_("windowDidDeminiaturize:")
	, sel_windowDidMiniaturize_("windowDidMiniaturize:")
	, sel_windowDidMove_("windowDidMove:")
	, sel_windowDidResignKey_("windowDidResignKey:")
	, sel_windowDidResize_("windowDidResize:")
	, sel_windowFrameColor("windowFrameColor")
	, sel_windowFrameTextColor("windowFrameTextColor")
	, sel_windowNumber("windowNumber")
	, sel_windowNumberAtPoint_belowWindowWithWindowNumber_("windowNumberAtPoint:belowWindowWithWindowNumber:")
	, sel_windowRef("windowRef")
	, sel_windowShouldClose_("windowShouldClose:")
	, sel_windowWillClose_("windowWillClose:")
	, sel_windowWithWindowNumber_("windowWithWindowNumber:")
	, sel_windows("windows")
	, sel_worksWhenModal("worksWhenModal")
	, sel_wraps("wraps")
	, sel_writeObjects_("writeObjects:")
	, sel_writeSelectionToPasteboard_types_("writeSelectionToPasteboard:types:")
	, sel_yearOfCommonEra("yearOfCommonEra")
	, sel_zoom_("zoom:")
;
	final String name;
	final long value;

	private Selector(String name) {
		this.name= name;
		this.value = OS.sel_registerName(name);
		OS.registerSelector(value,this);
	}

	public static Selector valueOf(long value) {
		return OS.getSelector(value);
	}

}